<?php
/**
 * GDF Core
 *
 * Handles setting up the GDF theme.
 *
 * @author   AyeCode
 * @category API
 * @package  GDF/Core
 * @since    2.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class GDF_Admin {

	/**
	 * Setup class.
	 *
	 * @since 2.0.0
	 */
	public function __construct() {
//		// Add query vars
//		add_filter( 'query_vars', array( $this, 'add_query_vars' ), 0 );
//
//		// Register auth endpoint
//		add_action( 'init', array( __CLASS__, 'add_endpoint' ), 0 );
//
//		// Handle auth requests
//		add_action( 'parse_request', array( $this, 'handle_auth_requests' ), 0 );
//
//		// Process login
//		add_action( 'wp_loaded', array( __CLASS__, 'process_login' ), 20 );

		$this->includes();

		add_action( 'tgmpa_register', array($this, 'required_plugins') );
	}

	/**
	 * Include required files.
	 *
	 * @access private
	 * @since 2.0.0
	 * @return void
	 */
	private function includes() {
		global $pagenow, $wp_version;

		// TGM plugin activation, for requiring plugins
		require_once( GDF_DIR . '/includes/libraries/class-tgm-plugin-activation.php' );
		require_once( GDF_DIR . '/includes/admin/class-gdf-admin-settings.php' );

	}

	public function required_plugins(){
		/*
			 * Array of plugin arrays. Required keys are name and slug.
			 * If the source is NOT from the .org repo, then source is also required.
			 */
		$plugins = array(

			array(
				'name' 		=> 'Redux Framework',
				'slug' 		=> 'redux-framework',
				'required' 	=> true,
			)

		);

		/*
		 * Array of configuration settings. Amend each line as needed.
		 *
		 * TGMPA will start providing localized text strings soon. If you already have translations of our standard
		 * strings available, please help us make TGMPA even better by giving us access to these translations or by
		 * sending in a pull-request with .po file(s) with the translations.
		 *
		 * Only uncomment the strings in the config array if you want to customize the strings.
		 */
		$config = array(
			'id'           => 'geodirectory_framework',                 // Unique ID for hashing notices for multiple instances of TGMPA.
			'default_path' => '',                      // Default absolute path to bundled plugins.
			'menu'         => 'tgmpa-install-plugins', // Menu slug.
			'has_notices'  => true,                    // Show admin notices or not.
			'dismissable'  => false,                    // If false, a user cannot dismiss the nag message.
			'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
			'is_automatic' => true,                   // Automatically activate plugins after installation or not.
			'message'      => '',                      // Message to output right before the plugins table.
		);

		tgmpa( $plugins, $config );
	}

}
new GDF_Admin();